function resetFilter(apply)
{
    if (document.adminForm.filter_assign) {
        document.adminForm.filter_assign.value = "M";
    }
    if (document.adminForm.id_client) {
        document.adminForm.id_client.value = "0";
    }
    if (document.adminForm.id_status) {
        document.adminForm.id_status.value = "WIP";
    }
    if (document.adminForm.filter_status) {
        document.adminForm.filter_status.value = "WIP";
    }
    if (document.adminForm.id_user) {
        document.adminForm.id_user.value = "0";
    }
    if (document.adminForm.filter_tickets) {
        document.adminForm.filter_tickets.value = "0";
    }
    if (document.adminForm.filter_category) {
        document.adminForm.filter_category.value = "";
    }
    if (document.adminForm.filter_search) {
        document.adminForm.filter_search.value = "";
    }
    if (document.adminForm.searchuser) {
        document.adminForm.searchuser.value = "";
    }
    if (document.adminForm.filter_workgroup) {
        document.adminForm.filter_workgroup.value = "0";
    }
    if (document.adminForm.filter_client) {
        document.adminForm.filter_client.value = "0";
    }
    if (document.adminForm.filter_user) {
        document.adminForm.filter_user.value = "0";
    }
    if (document.adminForm.ac_me) {
        document.adminForm.ac_me.value = "";
    }
}

function trimNumber(s)
{
    while (s.substr(0, 1) == '0' && s.length > 1)
    {
        s = s.substr(1, 9999);
    }
    return s;
}

/*
 Change the status of the ticket from here by ajax
 */
function SetTicketStatus(TICKET, STATUS, WORKGROUP) {
    jQuery.ajax({
        url:SITEURL + 'index.php?option=com_maqmahelpdesk&task=ticket_setstatus&id_workgroup=' + WORKGROUP + '&ticket=' + TICKET + '&status=' + STATUS + '&format=raw&tmpl=component',
        dataType:"html",
        error:function (data) {
        },
        success:function (data) {
            var msg = data.split("|");
            jQuery("#statuschange" + TICKET).html(msg[0]+'<span class="caret"></span>');
            jQuery("#adminForm").parent().prepend('<div class="alert alert-success">' + msg[1] + '</div>');
        }
    });
}

function SetTicketAssignment(TICKET, USER) {
    alert('change ticket ' + TICKET + ' support user to ' + USER);
}

function TicketSticky(OBJ, TICKET, WORKGROUP, ITEMID, ACTION, TABLE) {
    jQuery(OBJ).find("img").attr("src", SITEURL + "components/com_maqmahelpdesk/images/loading.gif");
    jQuery.ajax({
        url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=ticket_sticky&id_workgroup=' + WORKGROUP + '&ticket=' + TICKET + '&action=' + ACTION + '&format=raw&tmpl=component',
        dataType:"html",
        error:function (data) {
        },
        success:function (data) {
            var msg = data.split("|");
            jQuery("#adminForm").parent().prepend('<div class="alert alert-success">' + msg[1] + '</div>');
            if (ACTION) {
                jQuery(OBJ).find("img").attr("src", SITEURL + "/media/com_maqmahelpdesk/images/themes/" + IMQM_ICON_THEME + "/16px/lock.png");
            } else {
                jQuery(OBJ).find("img").attr("src", SITEURL + "/media/com_maqmahelpdesk/images/themes/" + IMQM_ICON_THEME + "/16px/unlock.png");
            }
        }
    });
}

function BugtrackerReply(WORKGROUP, CATEGORY, ITEMID, ID_BUGTRACKER) {
    if (jQuery("#reply").val() != '') {
        jQuery.ajax({
            url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=bugtracker_reply&id_workgroup=' + WORKGROUP + '&id_category=' + CATEGORY + '&id=' + ID_BUGTRACKER + '&format=raw&tmpl=component',
            dataType:"html",
            type:"post",
            data:"answer=" + jQuery("#reply").val(),
            error:function (data) {
            },
            success:function (data) {
                var msg = data.split("|");
                if (msg[1] != '') {
                    jQuery("#bugtracker").prepend('<div class="alert alert-success">' + msg[1] + '</div>');
                }
            }
        });
    }
}

function DiscussionReply(WORKGROUP, CATEGORY, ITEMID, ID_DISCUSSION)
{
    if (jQuery("#answer_text").val() != '') {
        jQuery.ajax({
            url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=discussions_answer&id_workgroup=' + WORKGROUP + '&id_category=' + CATEGORY + '&id_discussion=' + ID_DISCUSSION + '&format=raw&tmpl=component',
            dataType:"html",
            type:"post",
            data:"answer=" + jQuery("#answer_text").val() + "&valcalc=" + jQuery("#valcalc").val(),
            error:function (data) {
            },
            success:function (data) {
                var msg = data.split("|");
                if (msg[1] != '')
                {
                    jQuery("#discussions div.alert").remove();
                    jQuery("#discussions").prepend('<div class="alert alert-success">' + msg[1] + '</div>');
                    jQuery("#answer_text").val('').setCode('');
                    jQuery("#valcalc").val('');
                }
            }
        });
    }
}

function DiscussionVote(WORKGROUP, CATEGORY, ITEMID, ID_DISCUSSION, ID_MESSAGE, UPDOWN) {
    jQuery.ajax({
        url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=discussions_vote&id_workgroup=' + WORKGROUP + '&id_category=' + CATEGORY + '&id_discussion=' + ID_DISCUSSION + '&id_message=' + ID_MESSAGE + '&updown=' + UPDOWN + '&format=raw&tmpl=component',
        dataType:"html",
        error:function (data) {
        },
        success:function (data) {
            var msg = data.split("|");
            if (msg[1] != '') {
                msgTitle = ( msg[0] == 0 ? 'error' : 'success' );
                msgImage = ( msg[0] == 0 ? 'error.png' : 'success.png' );
                jQuery("#discussions").prepend('<div class="alert alert-' + msg[0] + '">' + msg[1] + '</div>');
            }
        }
    });
}

function DiscussionPublish(WORKGROUP, CATEGORY, ITEMID, ID_DISCUSSION, ID_MESSAGE) {
    jQuery.ajax({
        url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=discussions_publish&id_workgroup=' + WORKGROUP + '&id_category=' + CATEGORY + '&id_discussion=' + ID_DISCUSSION + '&id_message=' + ID_MESSAGE + '&format=raw&tmpl=component',
        dataType:"html",
        error:function (data) {
        },
        success:function (data) {
            var msg = data.split("|");
            if (msg[1] != '') {
                jQuery("#discussions").prepend('<div class="alert alert-success">' + msg[1] + '</div>');
                jQuery(".unpublished").hide();
            }
        }
    });
}

function DiscussionAccept(WORKGROUP, CATEGORY, ITEMID, ID_DISCUSSION, ID_MESSAGE) {
    jQuery.ajax({
        url:SITEURL + 'index.php?option=com_maqmahelpdesk&Itemid=' + ITEMID + '&task=discussions_accept&id_workgroup=' + WORKGROUP + '&id_category=' + CATEGORY + '&id_discussion=' + ID_DISCUSSION + '&id_message=' + ID_MESSAGE + '&format=raw&tmpl=component',
        dataType:"html",
        error:function (data) {
        },
        success:function (data) {
            var msg = data.split("|");
            if (msg[1] != '') {
                jQuery("#select_button").hide();
                jQuery("#discussions").prepend('<div class="alert alert-success">' + msg[1] + '</div>');
            }
        }
    });
}

function TicketEmailRemove(OBJ, FIELD) {
    jQuery(OBJ).parent().remove();
    jQuery("#" + FIELD).parent().css("height", parseInt(jQuery("#" + FIELD).css("height")) + 60);
}

function SearchView(TYPE) {
    if (TYPE == 'spl') {
        jQuery("#filters-simple").show();
        jQuery("#filters").hide();
        jQuery("#filters2").html('');
        jQuery("#tview").appendTo("#filters2");
        jQuery(".customStyleSelectBox").appendTo("#filters2");
        jQuery("<span>&nbsp;</span>").appendTo("#filters2");
        jQuery("#searchtickets").appendTo("#filters2");
        jQuery("#adv-options div").appendTo("#filters1");
    } else {
        jQuery("#filters-simple").hide();
        jQuery("#filters").show();
        jQuery("#tview").appendTo("#adv-tview");
        jQuery(".customStyleSelectBox").appendTo("#adv-tview");
        jQuery("#searchtickets").appendTo("#adv-buttons");
        jQuery("#filters1 div").appendTo("#adv-options");
    }
}

function DueDatePonderado() {
    jQuery.ajax({
        type:"POST",
        url:SITEURL + "index.php?option=com_maqmahelpdesk&Itemid=" + jQuery("#Itemid").val() + "&task=ajax_duedate&format=raw&p=" + jQuery("#id_priority").val() + "&s=" + jQuery("#assign_to").val() + "&w=" + jQuery("#id_workgroup").val(),
        success:function (msg) {
            DueDatePonderadoHandleResponse(msg);
        }
    });
}

function DueDatePonderadoHandleResponse(response) {
    var due = response.split(" ");
    jQuery("#duedate_date").val(due[0]);
    jQuery("#duedate_hours").val(due[1]);
}

function BulkPrint()
{
    if (jQuery('input.ticketchk:checked').length > 0)
    {
        IDS = '';
        jQuery.each(jQuery("input.ticketchk:checked"), function (index, value) {
            IDS += jQuery(this).val() + ',';
        });
        jQuery("#bulkactions #ids").val(IDS);
        jQuery("#bulkactions #task").val("pdf_ticketbulk");
        jQuery("#bulkactions").attr("target", "_blank").submit();
    }
}

function CreateSlug(FIELD)
{
    str = encodeURIComponent(jQuery("#" + FIELD).val());
    str = str.replace(/'/g, '-');

    jQuery.ajax({
        url:"index.php?option=com_maqmahelpdesk&task=ajax_slug&title=" + str + "&format=raw",
        success:function (data) {
            jQuery("#slug").val(data);
        }
    });
}

function IsLeap(ano, mes) {
    var IsLeap = parseInt(ano);
    IsLeap = !( IsLeap % 4 ) && ( ( IsLeap % 100 ) || !( IsLeap % 400 ) );
    IsLeap = [31, (IsLeap ? 29 : 28), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][mes - 1];
    return IsLeap;
}

jQuery(document).ready(
    function()
    {
        if (jQuery("#t3-mainbody").length)
        {
            jQuery(".nav-collapse.collapse").removeClass("nav-collapse").removeClass("collapse");
        }
        jQuery('.showPopover').popover({container: 'body', 'html':true, 'placement':'bottom', 'trigger':'hover'});
        jQuery('.showPopoverRight').popover({container: 'body', 'html':true, 'placement':'right', 'trigger':'hover'});
        jQuery('.showPopoverLeft').popover({container: 'body', 'html':true, 'placement':'left', 'trigger':'hover'});
        jQuery('.showPopoverLarger').popover({container: 'body', 'template':'<div class="popover larger"><div class="arrow"></div><div class="popover-inner larger"><h3 class="popover-title"></h3><div class="popover-content"><p></p></div></div></div>', 'html':true, 'placement':'bottom', 'trigger':'hover'});

        jQuery(".showPopover").bind('mouseout', function() { jQuery(this).show(); });
        jQuery(".showPopoverRight").bind('mouseout', function() { jQuery(this).show(); });
        jQuery(".showPopoverLeft").bind('mouseout', function() { jQuery(this).show(); });
        jQuery(".showPopoverLarger").bind('mouseout', function() { jQuery(this).show(); });

        if (!jQuery(".admin").length && !jQuery("body#minwidth-body").length)
        {
            jQuery(".modal").appendTo("body");
        }

        jQuery(".alertclose").click(function(){
            jQuery('#alertMessage').modal('hide');
        });
        if (jQuery(".artbycat").length > 0 )
        {
            jQuery(".artbycat").equalHeights();
        }
        if (jQuery(".discussion-category").length > 0 )
        {
            jQuery(".discussion-category").equalHeights();
        }
        if (jQuery(".equalheight").length > 0 )
        {
            jQuery(".equalheight").equalHeights();
            jQuery(".equalheight").css("height",(jQuery(".equalheight").css("height")+10));
        }
        jQuery('.tooltip').tooltip();
        jQuery('.tooltip-left').tooltip({placement:'left'});
        jQuery('.tooltip-right').tooltip({placement:'right'});
        jQuery('.tooltip-bottom').tooltip({placement:'bottom'});
        jQuery('.item_preview pre').addClass('prettyprint').addClass('linenums');

        // Administration UI
        if( parseInt(jQuery("#infobox").css("height")) < parseInt(jQuery("#contentbox").css("height")) ) {
            jQuery("#infobox").css("height", jQuery("#contentbox").css("height"));
        }
        jQuery('#infobox').css("width",(parseInt(jQuery('#infobox').css("width"))-2)+"px");

        // Search tweek for public discussions and kb
        if(jQuery("#maqmaSearchForm").length > 0 || jQuery("#maqmaSearchBugs").length > 0) {
            if(jQuery("#maqmaSearchForm").length > 0){
                width1 = jQuery("#maqmaSearchForm").width();
            }else{
                width1 = jQuery("#maqmaSearchBugs").width();
            }
            width2 = jQuery("#postQuestion").width();
            width3 = jQuery("#searchDiscussions").width();
            width4 = (width1 - width2 - width3 - 75);
            jQuery("#searchinput").width(width4);
        }

        // Close help box in administration
        jQuery("#mqmCloseHelp").click(function(){
            jQuery("#infobox").hide();
        });

        prettyPrint();

        if (MQM_BUILTIN_EDITOR == 'builtin')
        {
            var buttons_agent = ['html', '|', 'formatting', '|', 'bold', 'italic', 'underline', 'deleted', '|', 'unorderedlist', 'orderedlist', 'outdent', 'indent', '|', 'link', '|', 'fontcolor', 'backcolor'];
            var buttons_user = ['bold', 'italic', 'underline', '|', 'unorderedlist', 'orderedlist', 'outdent', 'indent', '|', 'fontcolor', 'backcolor'];
            jQuery('.redactor_agent').redactor({
                focus: false,
                buttons: buttons_agent,
                plugins: ['replies']
            });
            jQuery('.redactor_user').redactor({
                focus: false,
                buttons: buttons_user
            });
        }

        if (jQuery.browser.msie == true)
        {
            jQuery(".maqmahelpdesk .nav-collapse.collapse").css("height", "auto")
                                                           .css("overflow", "visible");
        }
    }
);

function FileNotify( ITEMID )
{
	jQuery.ajax({
		type: "POST",
		url: SITEURL+"index.php?option=com_maqmahelpdesk&Itemid="+ITEMID+"&task=ticket_notify&format=raw",
		data: "id="+jQuery("#id").val()
	});
}

function BulkDelete()
{
    if (jQuery('input.ticketchk:checked').length > 0)
    {
        IDS = '';
        jQuery.each(jQuery("input.ticketchk:checked"), function (index, value) {
            IDS += jQuery(this).val() + ',';
        });
        jQuery("#bulkactions #ids").val(IDS);
        jQuery("#bulkactions #task").val("ticket_delete");
        jQuery("#bulkactions").attr("target", "_self").submit();
    }
}

function SetTicketStatusBulk(STATUS)
{
    if (jQuery('input.ticketchk:checked').length > 0)
    {
        IDS = '';
        jQuery.each(jQuery("input.ticketchk:checked"), function (index, value) {
            IDS += jQuery(this).val() + ',';
        });
        jQuery("#bulkactions #ids").val(IDS);
        jQuery("#bulkactions").append('<input type="hidden" name="status" value="' + STATUS + '" />');
        jQuery("#bulkactions #task").val("ticket_setstatus");
        jQuery("#bulkactions").attr("target", "_self").submit();
    }
}